varying float rotation;
varying vec2 uvPosition;
varying float v_alpha; // these shouldn't be variable
varying vec3 v_color;

uniform float u_frameSize_x;
uniform float u_frameSize_y;


void main(void)
{
    vec2 coord = gl_PointCoord * vec2(u_frameSize_x, u_frameSize_y) + uvPosition;
    
    vec4 tex = texture2D(CC_Texture1, coord);
    tex *= vec4(v_color, v_alpha);
    if (tex.a < 0.05)
        discard;
    if (tex.a >= 0.05)
        gl_FragColor = tex;
}
